/*
 * gsignaldefine.cpp
 *
 *  Created on: 2024年10月11日
 *      Author: ZhangChundi
 */
#include "gsignaldefine.h"
#include <iostream>
#include "test/testa.h"

// 使用标准库中的函数时明确添加 std:: 命名空间前缀
int sum(int min, int max) {
    return min + max;
}

void printf_test(const char* test){
    printf(test);
}

DPS dpsInstance;  // 定义实际的对象
DPS& dps = dpsInstance;  // 将 dps 引用绑定到对象

DPS& DPS::signal(SigDefine &sigdefine) {
    std::cout << "SigDefine Type:" << sigdefine.type << std::endl;
    std::cout << "SigDefine Name:" << sigdefine.name << std::endl;
    std::cout << "SigDefine No:" << sigdefine.no << std::endl;
    std::map<int, std::string> maps = sigdefine.siteMaps;
    std::cout << "SigDefine Map Size:" << maps.size() << std::endl;
    for (std::map<int, std::string>::iterator it = maps.begin(); it != maps.end(); ++it) {
        std::cout << "site:" << it->first << "  " << "channel:" << it->second << std::endl;
    }
    return *this;
}

DPS& DPS::setMode(std::string mode) {
    std::cout << "mode:" << mode << std::endl;
    return *this;
}

ProjectOperate* ProjectOperate::instanceOwner = nullptr;
ProjectOperate* ProjectOperate::instance() {
	if (instanceOwner == nullptr) {
		std::cout << "ProjectOperate instance" << std::endl;
		instanceOwner = new ProjectOperate();
	}
	return instanceOwner;
}
