/*
 * CommonStruct.h
 *
 *  Created on: Mar 6, 2025
 *      Author: ZhangChundi
 */

#ifndef COMMONSTRUCT_H_
#define COMMONSTRUCT_H_

#include "json.hpp"

// 解析flow文件，flow文件是json格式
struct Level {
	std::string clampHi;
	std::string clampLow;
	std::string iOH;
	std::string iOL;
	std::string vIH;
	std::string vIL;
	std::string vOH;
	std::string vOL;
	std::string vT;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Level, clampHi, clampLow, iOH, iOL, vIH, vIL,
		vOH, vOL, vT)

struct Result {
	std::string max;
	std::string min;
	int paramId;
	std::string paramName;
	std::string unit;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Result, max, min, paramId, paramName, unit)

struct TestItem {
	std::string failJump;
	std::string flag;
	std::string funcDesc;
	int funcId;
	std::string funcName;
	int hbin;
	Level level;
	int loop;
	std::string passJump;
	std::string pattern;
	std::vector<Result> results;
	int sbin;
	bool select;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(TestItem, failJump, flag, funcDesc, funcId,
		funcName, hbin, level, loop, passJump, pattern, results, sbin, select)

struct FlowMessage {
	std::vector<TestItem> testItems;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(FlowMessage, testItems)

// 解析设置文件，通常在测试工程的.setting/目录下
struct ExecuteSetting {
    bool failstop = false;
    int loopcount = 1;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(ExecuteSetting, failstop, loopcount);

struct DUTSetting {
    std::vector<std::string> selectDUT;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(DUTSetting, selectDUT);

struct Setting {
    ExecuteSetting executeSetting;
    DUTSetting dutSetting;
};
NLOHMANN_DEFINE_TYPE_NON_INTRUSIVE(Setting, executeSetting, dutSetting);

struct Configure {
	FlowMessage flowMessage;
	Setting setting;
	Configure(FlowMessage& flowMessage, Setting& setting)
		: flowMessage(flowMessage), setting(setting) {}
};

class CommonStruct {
public:
	CommonStruct();
	virtual ~CommonStruct();
};

#endif /* COMMONSTRUCT_H_ */
