//============================================================================
// Name        : driver.cpp
// Author      :
// Version     :
// Copyright   : Your copyright notice
// Description : Hello World in C, Ansi-style
//============================================================================
// driver.h (exe project)

#include "driver.h"
#include "../utils/json.hpp"
#include "CommandParser.h"

// 常量字符串
const char COMMAND_MARK = '^';
const string EXIT_MARK = "exit";
const string SUCCESS_STR = "done";
const string FAIL_STR = "error";

DriverCommon common;
CommandParser parser(common);

int main(){
    int process = 0;
    while(true) {
        Sleep(100);
        process += 10;
        cout << "[process:" << process << "]" <<endl;
        if (process == 100){
        	break;
        }
    }
    cout << "input 'exit' exit process." << endl;
    string input;
	// 1^gk -p load <parameter>
    while (true) {
    	// 读取整行输入，包括空格
        std::getline(std::cin, input);
        // 检查退出条件
        if (input == EXIT_MARK) {
			break;
		}
        if (input == "") {
        	continue;
        }
		// 认为是命令，处理命令并反馈结果
		ParsedCommand cmd;
		if (parser.parse(input, cmd)) {
			if (!parser.isValidCommand(cmd.fullCommand)) {
				std::cerr << "Unknown command: " << cmd.fullCommand << std::endl;
				continue;
			}
			int isSuccess = parser.handleCommand(cmd);
			// 反馈结果
			if (isSuccess == 0) {
				printString(cmd.number, COMMAND_MARK, SUCCESS_STR);
			} else {
				printString(cmd.number, COMMAND_MARK, FAIL_STR,
						",", "error info=", std::to_string(isSuccess));
			}
		} else {
			// 命令输入错误
			std::cerr << "Command format is error." << std::endl;
		}
    }
	return 0;
}
