/*
 * CommandParser.h
 *
 *  Created on: Mar 4, 2025
 *      Author: ZhangChundi
 */

#ifndef COMMANDPARSER_H_
#define COMMANDPARSER_H_

#include <string>
#include <vector>
#include <unordered_set>
#include <regex>
#include <iostream>
#include "../utils/DriverCommon.h"
#include "../utils/PrintHelper.cpp"
#include "../utils/ErrorType.h"
#include <windows.h>

// IDE发来的命令解析后的结果
struct ParsedCommand {
    std::string number;
    std::string fullCommand;
    std::vector<std::string> args;
};

enum CommandType { LOAD, UNLOAD, RUN, STOP, UNKNOWN };

/** 动态调用测试工程中的测试项函数 */
typedef bool (*FunctionTypeStr)(const Configure);

/** 测试工程加载调用 */
typedef bool (*PrjInit)(void);
/** 测试工程卸载调用 */
//typedef bool (*PrjExit)(void);
/** 测试工程所有测试项每次被调用前调用 */
typedef bool (*TestStart)(const DUTSetting);
/** 测试工程所有测试项每次被调用结束后调用 */
typedef bool (*TestEnd)(void);

// 命令解析器
class CommandParser {
private:
	// Parameter
	DriverCommon common;
	FlowMessage flowMessage;
	Setting setting;
	std::string dllFilePath;

	std::vector<std::string> validCommands;

	bool callFuncs(const Configure& configure, const DUTSetting &dutSetting);
	void executeLoopAllFunc(const Configure& configure, const std::string number);
	void executeAllFunc(const Configure& configure);
	int runDll(ParsedCommand &command);
	int stopDll();

	int loadDll(const std::vector<std::string> args);
	CommandType string2command(const std::string& cmd);

	int testStart(const DUTSetting &dutSetting);
	int testEnd();
public:
	// Method
    CommandParser(DriverCommon common);
    bool parse(const std::string& input, ParsedCommand& result) const;
    bool isValidCommand(const std::string& cmd) const;
    int handleCommand(ParsedCommand& command);
};

#endif /* COMMANDPARSER_H_ */
