/*
 * gsignaldefine.h
 *
 *  Created on: 2024年10月11日
 *      Author: ZhangChundi
 */

#ifndef GSIGNALDEFINE_H_
#define GSIGNALDEFINE_H_

#include <string>
#include <iostream>
#include <map>
#include <vector>

class SigDefine {
public:
    std::string name;
    std::string type;
    std::string no;
    std::map<int, std::string> siteMaps;

    explicit SigDefine(std::string name, std::string type, std::string no, std::map<int, std::string> siteMaps)
    {
        this->name = name;
        this->type = type;
        this->no = no;
        this->siteMaps = siteMaps;
    }
};

class GroupDefine {
public:
    std::string name;
    std::string type;
    std::vector<SigDefine> signals;

    explicit GroupDefine(std::string name, std::string type, std::vector<SigDefine> signals)
    {
        this->name = name;
        this->type = type;
        this->signals = signals;
    }
};

class PatternDefine {
public:
    std::string name;
    std::string file;
    std::string state;

    explicit PatternDefine(std::string name, std::string file, std::string state)
    {
        this->name = name;
        this->file = file;
        this->state = state;
    }
};

class DPS {
public:
    DPS() {}

    DPS& signal(SigDefine &sigdefine);

    DPS& setMode(std::string mode);
};

class ProjectOperate {
private:
	static ProjectOperate *instanceOwner;
    explicit ProjectOperate() {}
    ~ProjectOperate() {
    	delete instanceOwner;
    }
public:
	static ProjectOperate* instance();
};


extern "C" {
    void printf_test(const char* test);
    int sum(int min, int max);
    extern DPS& dps;
}

#endif /* GSIGNALDEFINE_H_ */
