/*
 * PrintHelper.cpp
 *
 *  Created on: Mar 4, 2025
 *      Author: ZhangChundi
 */

#include <iostream>
#include <sstream>
#include <vector>
#include <array>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <list>
#include <deque>

// 控制开关，DEBUG模式下打开，RELEASE模式下关闭
#ifdef ENABLE_CONTAINER_PRINT

#define PRINT_CONTAINER(container) printContainer(container)
#define PRINT_MAP(map) printMap(map)

#else

#define PRINT_CONTAINER(container)
#define PRINT_MAP(map)

#endif

template<typename... Args>
void printString(Args&&... args) {
    std::ostringstream oss;
    //(oss << ... << args);  // C++17折叠表达式，把参数一个个拼起来
    int dummy[] = {0, (oss << args, 0)...};  // 用逗号表达式展开参数
    (void)dummy; // 避免未使用变量的警告
    std::cout << oss.str() << std::endl;
};

template<typename... ArgsErr>
void printErr(ArgsErr&&... args) {
    std::ostringstream oss;
    //(oss << ... << args);  // C++17折叠表达式，把参数一个个拼起来
    int dummy[] = {0, (oss << args, 0)...};  // 用逗号表达式展开参数
    (void)dummy; // 避免未使用变量的警告
    std::cerr << oss.str() << std::endl;
};

// 通用容器打印，适合vector/array/set/list/deque
template<typename Container>
void printContainer(const Container& container, const std::string& name = "container") {
    std::cout << name << " = [";
    bool first = true;
    for (const auto& item : container) {
        if (!first) std::cout << ", ";
        std::cout << item;
        first = false;
    }
    std::cout << "]" << std::endl;
}

// 专门打印map和unordered_map
template<typename MapType>
void printMap(const MapType& m, const std::string& name = "map") {
    std::cout << name << " = {" << std::endl;
    for (const auto& pair : m) {
        std::cout << "  " << pair.first << ": " << pair.second << "," << std::endl;
    }
    std::cout << "}" << std::endl;
}
