/*
 * DriverCommon.h
 *
 *  Created on: 2024年11月1日
 *      Author: ZhangChundi
 */

#ifndef SRC_DRIVERCOMMON_H_
#define SRC_DRIVERCOMMON_H_

#include <iostream>
#include <sstream>
#include <fstream>
#include <filesystem>

#include <string>
#include <vector>
#include "CommonStruct.h"

/**
 * 通用函数，文件解析，字符串处理
 */
class DriverCommon {
public:
	DriverCommon();

	std::vector<std::string> split(const std::string& str, char delimiter);
	std::optional<FlowMessage> analysisFlowFile(std::string filePath);
	std::optional<Setting> analysisSettingFile(std::string filePath);

	bool fileExists(const std::string& path);

	virtual ~DriverCommon();
};

#endif /* SRC_DRIVERCOMMON_H_ */
